/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.entry;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.hooks.item.ItemStackHooks;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.AbstractEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.BatchedEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1074;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_6862;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class ItemEntryDefinition
implements EntryDefinition<class_1799>,
EntrySerializer<class_1799> {
    @Environment(value=EnvType.CLIENT)
    private EntryRenderer<class_1799> renderer;
    private static final ReferenceSet<class_1792> SEARCH_BLACKLISTED = new ReferenceOpenHashSet();

    public ItemEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> Client.init(this));
    }

    @Override
    public Class<class_1799> getValueType() {
        return class_1799.class;
    }

    @Override
    public EntryType<class_1799> getType() {
        return VanillaEntryTypes.ITEM;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public EntryRenderer<class_1799> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public class_2960 getIdentifier(EntryStack<class_1799> entry, class_1799 value) {
        return class_2378.field_11142.method_10221((Object)value.method_7909());
    }

    @Override
    public boolean isEmpty(EntryStack<class_1799> entry, class_1799 value) {
        return value.method_7960();
    }

    @Override
    public class_1799 copy(EntryStack<class_1799> entry, class_1799 value) {
        return value.method_7972();
    }

    @Override
    public class_1799 normalize(EntryStack<class_1799> entry, class_1799 value) {
        class_1799 copy = value.method_7972();
        copy.method_7939(1);
        return copy;
    }

    @Override
    public class_1799 wildcard(EntryStack<class_1799> entry, class_1799 value) {
        return new class_1799((class_1935)value.method_7909(), 1);
    }

    @Override
    @Nullable
    public class_1799 cheatsAs(EntryStack<class_1799> entry, class_1799 value) {
        return value.method_7972();
    }

    @Override
    @Nullable
    public class_1799 add(class_1799 o1, class_1799 o2) {
        return ItemStackHooks.copyWithCount((class_1799)o1, (int)(o1.method_7947() + o2.method_7947()));
    }

    @Override
    public long hash(EntryStack<class_1799> entry, class_1799 value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + System.identityHashCode(value.method_7909());
        code = 31 * code + Long.hashCode(ItemComparatorRegistry.getInstance().hashOf(context, value));
        return code;
    }

    @Override
    public boolean equals(class_1799 o1, class_1799 o2, ComparisonContext context) {
        if (o1.method_7909() != o2.method_7909()) {
            return false;
        }
        return ItemComparatorRegistry.getInstance().hashOf(context, o1) == ItemComparatorRegistry.getInstance().hashOf(context, o2);
    }

    @Override
    @Nullable
    public EntrySerializer<class_1799> getSerializer() {
        return this;
    }

    @Override
    public boolean supportSaving() {
        return true;
    }

    @Override
    public boolean supportReading() {
        return true;
    }

    @Override
    public boolean acceptsNull() {
        return false;
    }

    @Override
    public class_2487 save(EntryStack<class_1799> entry, class_1799 value) {
        return value.method_7953(new class_2487());
    }

    @Override
    public class_1799 read(class_2487 tag) {
        return class_1799.method_7915((class_2487)tag);
    }

    @Override
    public class_2561 asFormattedText(EntryStack<class_1799> entry, class_1799 value) {
        return this.asFormattedText(entry, value, TooltipContext.of());
    }

    @Override
    public class_2561 asFormattedText(EntryStack<class_1799> entry, class_1799 value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.method_7909())) {
            try {
                return value.method_7964();
            }
            catch (Throwable e) {
                if (context != null && context.isSearch()) {
                    throw e;
                }
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.method_7909());
            }
        }
        try {
            return class_2561.method_43470((String)class_1074.method_4662((String)("item." + class_2378.field_11142.method_10221((Object)value.method_7909()).toString().replace(":", ".")), (Object[])new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return class_2561.method_43470((String)"ERROR");
        }
    }

    @Override
    public Stream<? extends class_6862<?>> getTagsFor(EntryStack<class_1799> entry, class_1799 value) {
        return value.method_40133();
    }

    @Environment(value=EnvType.CLIENT)
    private List<class_2561> tryGetItemStackToolTip(EntryStack<class_1799> entry, class_1799 value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.method_7909())) {
            try {
                return value.method_7950((class_1657)class_310.method_1551().field_1724, context.getFlag());
            }
            catch (Throwable e) {
                if (context.isSearch()) {
                    throw e;
                }
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.method_7909());
            }
        }
        return Lists.newArrayList((Object[])new class_2561[]{this.asFormattedText(entry, value, context)});
    }

    @Override
    public void fillCrashReport(class_128 report, class_129 category, EntryStack<class_1799> entry) {
        EntryDefinition.super.fillCrashReport(report, category, entry);
        class_1799 stack = entry.getValue();
        category.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
        category.method_577("Item Damage", () -> String.valueOf(stack.method_7919()));
        category.method_577("Item NBT", () -> String.valueOf(stack.method_7969()));
        category.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
    }

    @Environment(value=EnvType.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init(ItemEntryDefinition definition) {
            definition.renderer = definition.new ItemEntryRenderer();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ItemEntryRenderer
    extends AbstractEntryRenderer<class_1799>
    implements BatchedEntryRenderer<class_1799, class_1087> {
        private static final float SCALE = 20.0f;
        public static final int ITEM_LIGHT = 0xF000F0;

        @Override
        public class_1087 getExtraData(EntryStack<class_1799> entry) {
            return class_310.method_1551().method_1480().method_4019(entry.getValue(), null, null, 0);
        }

        @Override
        public void render(EntryStack<class_1799> entry, class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            class_1087 model = this.getExtraData(entry);
            this.setupGL(entry, model);
            if (!entry.isEmpty()) {
                class_1799 value = entry.getValue();
                matrices.method_22903();
                matrices.method_34425(RenderSystem.getModelViewMatrix());
                matrices.method_22904((double)bounds.getCenterX(), (double)bounds.getCenterY(), (double)entry.getZ());
                matrices.method_22905((float)bounds.getWidth(), (float)(bounds.getWidth() + bounds.getHeight()) / -2.0f, 1.0f);
                class_4587 modelViewStack = RenderSystem.getModelViewStack();
                modelViewStack.method_22903();
                modelViewStack.method_23760().method_23761().method_35434(matrices.method_23760().method_23761());
                RenderSystem.applyModelViewMatrix();
                class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
                class_310.method_1551().method_1480().method_23179(value, class_809.class_811.field_4317, false, new class_4587(), (class_4597)immediate, 0xF000F0, class_4608.field_21444, model);
                immediate.method_22993();
                matrices.method_22909();
                modelViewStack.method_22909();
                RenderSystem.applyModelViewMatrix();
            }
            class_4587 modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.method_22903();
            modelViewStack.method_34425(matrices.method_23760().method_23761());
            modelViewStack.method_22904((double)bounds.x, (double)bounds.y, 0.0);
            modelViewStack.method_22905((float)bounds.width / 16.0f, (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f / 16.0f, 1.0f);
            RenderSystem.applyModelViewMatrix();
            this.renderOverlay(entry, bounds);
            modelViewStack.method_22909();
            this.endGL(entry, model);
            RenderSystem.applyModelViewMatrix();
        }

        @Override
        public int getBatchIdentifier(EntryStack<class_1799> entry, Rectangle bounds, class_1087 model) {
            return 1738923 + (model.method_24304() ? 1 : 0);
        }

        @Override
        public void startBatch(EntryStack<class_1799> entry, class_1087 model, class_4587 matrices, float delta) {
            this.setupGL(entry, model);
            class_4587 modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.method_22903();
            modelViewStack.method_22905(20.0f, -20.0f, 1.0f);
            RenderSystem.applyModelViewMatrix();
        }

        public void setupGL(EntryStack<class_1799> entry, class_1087 model) {
            class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean sideLit = model.method_24304();
            if (!sideLit) {
                class_308.method_24210();
            }
        }

        @Override
        public void renderBase(EntryStack<class_1799> entry, class_1087 model, class_4587 matrices, class_4597.class_4598 immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (!entry.isEmpty()) {
                class_1799 value = entry.getValue();
                matrices.method_22903();
                matrices.method_22904((double)((float)bounds.getCenterX() / 20.0f), (double)((float)bounds.getCenterY() / -20.0f), (double)entry.getZ());
                matrices.method_22905((float)bounds.getWidth() / 20.0f, (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f / 20.0f, 1.0f);
                class_310.method_1551().method_1480().method_23179(value, class_809.class_811.field_4317, false, matrices, (class_4597)immediate, 0xF000F0, class_4608.field_21444, model);
                matrices.method_22909();
            }
        }

        @Override
        public void afterBase(EntryStack<class_1799> entry, class_1087 model, class_4587 matrices, float delta) {
            this.endGL(entry, model);
            RenderSystem.getModelViewStack().method_22909();
            RenderSystem.applyModelViewMatrix();
        }

        @Override
        public void renderOverlay(EntryStack<class_1799> entry, class_1087 model, class_4587 matrices, class_4597.class_4598 immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
            class_4587 modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.method_22903();
            modelViewStack.method_34425(matrices.method_23760().method_23761());
            modelViewStack.method_22904((double)bounds.x, (double)bounds.y, 0.0);
            modelViewStack.method_22905((float)bounds.width / 16.0f, (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f / 16.0f, 1.0f);
            RenderSystem.applyModelViewMatrix();
            this.renderOverlay(entry, bounds);
            modelViewStack.method_22909();
            RenderSystem.applyModelViewMatrix();
        }

        public void renderOverlay(EntryStack<class_1799> entry, Rectangle bounds) {
            if (!entry.isEmpty()) {
                class_310.method_1551().method_1480().field_4730 = entry.getZ();
                class_310.method_1551().method_1480().method_4022(class_310.method_1551().field_1772, entry.getValue(), 0, 0, null);
                class_310.method_1551().method_1480().field_4730 = 0.0f;
            }
        }

        @Override
        public void endBatch(EntryStack<class_1799> entry, class_1087 model, class_4587 matrices, float delta) {
        }

        public void endGL(EntryStack<class_1799> entry, class_1087 model) {
            RenderSystem.enableDepthTest();
            boolean sideLit = model.method_24304();
            if (!sideLit) {
                class_308.method_24211();
            }
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<class_1799> entry, TooltipContext context) {
            if (entry.isEmpty()) {
                return null;
            }
            Tooltip tooltip = Tooltip.create(new class_2561[0]);
            Optional component = entry.getValue().method_32347();
            List<class_2561> components = ItemEntryDefinition.this.tryGetItemStackToolTip(entry, entry.getValue(), context);
            if (!components.isEmpty()) {
                tooltip.add(components.get(0));
            }
            component.ifPresent(tooltip::add);
            for (int i = 1; i < components.size(); ++i) {
                tooltip.add(components.get(i));
            }
            return tooltip;
        }
    }
}

